import {createSelector} from 'reselect';
import uniq from 'lodash/uniq';

import {YANDEX_REQUISITES} from 'constants/requisites';

import {isNotUndefined} from 'types/utilities';
import IPartnerRequisites from 'components/PartnersRequisites/types/IPartnerRequisites';

import trainListSelector from 'selectors/trains/order/trainListSelector';

import preparePartner from 'components/PartnersRequisites/utilities/preparePartner';

import partnersData from '../partners.json';

const partnersSelectors = createSelector(
    [trainListSelector],
    (trains): IPartnerRequisites[] => {
        const owners = trains.map(train => {
            return train.coach?.owner;
        });

        const rawPartners = [
            ...uniq(owners)
                .map(owner => {
                    if (owner && owner in partnersData) {
                        return partnersData[owner as keyof typeof partnersData];
                    }

                    return undefined;
                })
                .filter(isNotUndefined),
            partnersData.IM,
            partnersData.insurance,
            YANDEX_REQUISITES,
        ];

        return rawPartners.map(preparePartner);
    },
);

export default partnersSelectors;
