import React, {useMemo} from 'react';
import {useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';

import passengersCountSelector from 'selectors/trains/order/passengersCountSelector';
import maxPlacesInCoachSelector from 'selectors/trains/order/maxPlacesInCoachSelector';
import tariffCategoriesSelector from 'selectors/trains/order/tariffCategoriesSelector';
import isCovidCertificateRequiredSelector from 'selectors/trains/order/isCovidCertificateRequiredSelector';
import currentTrainDetailsSelector from 'selectors/trains/order/currentTrainDetailsSelector';

import {getPassengersNotificationMessages} from './utilities/getPassengersNotificationMessages';

import Flex from 'components/Flex/Flex';
import NotificationNewMobile from 'projects/trains/components/NotificationNewMobile/NotificationNewMobile';

export interface IPassengersCountNotificationProps extends IWithClassName {}

const PassengersCountNotification: React.FC<IPassengersCountNotificationProps> =
    ({className}) => {
        const passengers = useSelector(passengersCountSelector);
        const maxPlaces = useSelector(maxPlacesInCoachSelector);
        const tariffCategories = useSelector(tariffCategoriesSelector);
        const isCovidCertificateRequired = useSelector(
            isCovidCertificateRequiredSelector,
        );
        const trainDetails = useSelector(currentTrainDetailsSelector);
        const isCppk = trainDetails?.isCppk;

        const {adults: adultsCount, children: childrenCount} = passengers;

        const messages = useMemo(() => {
            return getPassengersNotificationMessages({
                isCovidCertificateRequired,
                maxPlaces,
                adultsCount,
                childrenCount,
                tariffCategories,
                isCppk,
            });
        }, [
            isCovidCertificateRequired,
            maxPlaces,
            adultsCount,
            childrenCount,
            tariffCategories,
            isCppk,
        ]);

        if (messages.length === 0) {
            return null;
        }

        return (
            <Flex
                className={className}
                above={6}
                between={3}
                flexDirection="column"
            >
                {messages.map((msg, idx) => (
                    <NotificationNewMobile key={idx}>
                        {msg}
                    </NotificationNewMobile>
                ))}
            </Flex>
        );
    };

export default PassengersCountNotification;
