import {ITrainsTariffCategory} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';

import {getNotificationMessages} from 'projects/trains/components/TrainsOrderPage/PassengersNotification/utils';

import * as i18nBlock from 'i18n/trains-passengers-selector';

interface IGetNotificationMessagesParams {
    isCovidCertificateRequired: boolean;
    maxPlaces: number;
    adultsCount: number;
    childrenCount: number;
    tariffCategories?: ITrainsTariffCategory[];
    isCppk?: boolean;
}

export const getPassengersNotificationMessages = (
    params: IGetNotificationMessagesParams,
): string[] => {
    const messages = getNotificationMessages(params);

    if (params.isCppk) {
        messages.push(i18nBlock.babiesDashCppk());
    }

    return messages;
};
