import {MAX_PASSENGERS_COUNT_IN_ORDER} from 'projects/trains/constants/order';

import {
    ITrainsTariffCategory,
    TrainsTariffCategoryCode,
} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';

import * as i18nBlock from 'i18n/trains-passengers-selector';

interface IGetNotificationMessages {
    isCovidCertificateRequired: boolean;
    maxPlaces: number;
    adultsCount: number;
    childrenCount: number;
    tariffCategories?: ITrainsTariffCategory[];
}

export const getNotificationMessages = ({
    isCovidCertificateRequired,
    maxPlaces,
    adultsCount,
    childrenCount,
    tariffCategories,
}: IGetNotificationMessages): string[] => {
    const msgs = [];

    if (isCovidCertificateRequired) {
        msgs.push(i18nBlock.covidDashCertificateDashRequired());
    }

    if (maxPlaces < MAX_PASSENGERS_COUNT_IN_ORDER) {
        msgs.push(i18nBlock.couchDashPlaceDashLimit());
    }

    if (!adultsCount) {
        if (childrenCount) {
            const maxAge = tariffCategories?.find(
                category => category.code === TrainsTariffCategoryCode.CHILD,
            )?.maxAge;

            if (maxAge) {
                msgs.push(
                    i18nBlock.childrenDashWithoutDashAdultDashNew({
                        age: maxAge,
                    }),
                );
            }
        } else {
            msgs.push(i18nBlock.chooseDashAtDashLeastDashOneDashPassenger());
        }
    }

    return msgs;
};
