import {FunctionComponent, ReactNode} from 'react';
import {OnChange} from 'react-final-form-listeners';

import {IWithClassName} from 'types/withClassName';
import {
    EGroupName,
    EFieldName,
} from 'types/trains/booking/ITrainsBookFormValues';

import * as i18nBlock from 'i18n/trains-order-contacts';

import Form from 'components/Form/Form';
import Checkbox from 'components/Checkbox/Checkbox';

const FULL_FIELD_NAME = `${EGroupName.contacts}.${EFieldName.useOnlyMainContacts}`;

interface IAdditionalContactsCheckboxProps extends IWithClassName {
    initialValue?: boolean;
    onChange: (value: boolean) => void;
}

const AdditionalContactsCheckbox: FunctionComponent<IAdditionalContactsCheckboxProps> =
    ({className, initialValue, onChange}) => {
        return (
            <div className={className}>
                <Form.Field
                    name={FULL_FIELD_NAME}
                    initialValue={initialValue}
                    render={({input}): ReactNode => (
                        <Checkbox
                            label={i18nBlock.useContacts()}
                            checked={input.value}
                            onChange={input.onChange}
                            onFocus={input.onFocus}
                            onBlur={input.onBlur}
                        />
                    )}
                />
                <OnChange name={FULL_FIELD_NAME}>{onChange}</OnChange>
            </div>
        );
    };

export default AdditionalContactsCheckbox;
