import {useContext, useEffect, useMemo} from 'react';
import {useForm} from 'react-final-form';
import {useSelector} from 'react-redux';

import {
    EFieldName,
    IPassenger,
} from 'types/trains/booking/ITrainsBookFormValues';
import {IPassengerWithDocumentsAndBonusCardsDTO} from 'server/api/TravelersApi/types/IPassengerDTO';

import travelerSelector from 'selectors/trains/order/travelerSelector';

import getTravelerPassengerWithNotifications from 'projects/trains/components/TrainsOrderPage/PassengersStep/components/ContactsForm/components/EmailOrPhoneInput/hooks/useFillTravelerContacts/utilities/getTravelerPassengerWithNotifications';

import Form from 'components/Form/Form';

export default function useFillTravelerContacts(
    passenger: IPassenger | undefined,
): void {
    const form = useForm();
    const formGroupId = useContext(Form.FieldGroupContext);
    const traveler = useSelector(travelerSelector);

    const selectedTravelerPassengerWithNotifications =
        useMemo((): IPassengerWithDocumentsAndBonusCardsDTO | null => {
            if (!passenger) {
                return null;
            }

            return getTravelerPassengerWithNotifications(
                traveler.accountPassengers,
                passenger,
            );
        }, [passenger, traveler.accountPassengers]);

    useEffect(() => {
        form.change(
            `${formGroupId}.${EFieldName.additionalContact}`,
            selectedTravelerPassengerWithNotifications?.email ||
                selectedTravelerPassengerWithNotifications?.phone ||
                '',
        );
    }, [
        form,
        formGroupId,
        selectedTravelerPassengerWithNotifications?.email,
        selectedTravelerPassengerWithNotifications?.phone,
    ]);
}
