import {EFieldName} from 'components/BookingPassengerForm/constants/fieldNames';

import {IPassengerWithDocumentsAndBonusCardsDTO} from 'server/api/TravelersApi/types/IPassengerDTO';
import {IPassenger} from 'types/trains/booking/ITrainsBookFormValues';

import {parseDate} from 'utilities/dateUtils';
import {HUMAN_DATE_RU, ROBOT} from 'utilities/dateUtils/formats';

export default function getTravelerPassengerWithNotifications(
    travelerPassengers: IPassengerWithDocumentsAndBonusCardsDTO[],
    formPassenger: IPassenger,
): IPassengerWithDocumentsAndBonusCardsDTO | null {
    for (const travelerPassenger of travelerPassengers) {
        for (const travelerDocument of travelerPassenger.documents) {
            if (
                travelerPassenger.train_notifications_enabled &&
                travelerDocument.first_name ===
                    formPassenger[EFieldName.firstName] &&
                travelerDocument.last_name ===
                    formPassenger[EFieldName.lastName] &&
                travelerDocument.middle_name ===
                    formPassenger[EFieldName.patronymicName] &&
                travelerPassenger.gender === formPassenger[EFieldName.sex] &&
                parseDate(travelerPassenger.birth_date, ROBOT).format(
                    HUMAN_DATE_RU,
                ) === formPassenger[EFieldName.birthdate]
            ) {
                return travelerPassenger;
            }
        }
    }

    return null;
}
