import {IPassenger} from 'types/trains/booking/ITrainsBookFormValues';

import * as i18nBlock from 'i18n/trains-order-summary-details';

export default function getPassengerFullName(
    index: number,
    passenger?: IPassenger,
): string {
    if (!passenger) {
        return `${index + 1}. ${i18nBlock.itemDashTitleDashAdults()}`;
    }

    const {firstName = '', lastName = '', patronymicName = ''} = passenger;

    const name = [
        lastName,
        firstName,
        patronymicName === '-' ? '' : patronymicName,
    ]
        .join(' ')
        .trim();

    if (name) {
        return name;
    }

    return `${index + 1}. ${i18nBlock.itemDashTitleDashAdults()}`;
}
