import React, {useEffect, useCallback} from 'react';
import {useForm, FormSpy} from 'react-final-form';
import {FormState} from 'final-form';
import {useSelector} from 'react-redux';

import {
    EGroupName,
    EFieldName as ETrainFields,
    ITrainsBookFormValues,
} from 'types/trains/booking/ITrainsBookFormValues';

import formDataAdapterSelector from './selectors/formDataAdapterSelector';

import {saveFormInStorage} from './utilities/saveFormInStorage';
import {formatDate} from 'utilities/dateUtils';
import {HUMAN_DATE_RU} from 'utilities/dateUtils/formats';

const FormDataAdapter: React.FC = () => {
    const {
        passengers,
        orderGender,
        lastSegmentDeparture,
        lastSegmentArrival,
        userInfo,
    } = useSelector(formDataAdapterSelector);

    const {adults} = passengers;

    const formApi = useForm<ITrainsBookFormValues>();

    const handleFormChange = useCallback(
        ({values, modified = {}}: FormState<ITrainsBookFormValues>) => {
            // Сохраняем форму только в случае если пользователь взаимодействовал с ней
            if (Object.values(modified).some(Boolean)) {
                saveFormInStorage(values, userInfo);
            }
        },
        [userInfo],
    );

    useEffect(() => {
        formApi.batch(() => {
            formApi.change(
                `${EGroupName.trainInfo}.${ETrainFields.coachGender}` as any,
                orderGender,
            );
            formApi.change(
                `${EGroupName.trainInfo}.${ETrainFields.startDate}` as any,
                lastSegmentDeparture &&
                    formatDate(lastSegmentDeparture, HUMAN_DATE_RU),
            );
            formApi.change(
                `${EGroupName.trainInfo}.${ETrainFields.endDate}` as any,
                lastSegmentArrival &&
                    formatDate(lastSegmentArrival, HUMAN_DATE_RU),
            );
        });
    }, [formApi, orderGender, lastSegmentDeparture, lastSegmentArrival]);

    useEffect(() => {
        if (adults < 2) {
            formApi.change(
                `${EGroupName.contacts}.${ETrainFields.useOnlyMainContacts}` as any,
                true,
            );
        }
    }, [formApi, adults]);

    return (
        <FormSpy
            subscription={{values: true, modified: true}}
            onChange={handleFormChange}
        />
    );
};

export default FormDataAdapter;
