import {createStructuredSelector} from 'reselect';

import {GENDER_TYPE} from 'projects/trains/constants/genders';

import {TrainsPassengersCount} from 'reducers/trains/order/types';

import {StoreInterface} from 'reducers/storeTypes';
import {TUserInfo} from 'reducers/common/commonReducerTypes';

import orderGenderSelector from 'selectors/trains/order/passengers/orderGenderSelector';
import passengersCountSelector from 'selectors/trains/order/passengersCountSelector';
import lastSegmentDepartureSelector from 'selectors/trains/order/passengers/lastSegmentDepartureSelector';
import lastSegmentArrivalSelector from 'selectors/trains/order/passengers/lastSegmentArrivalSelector';
import {getUserInfo} from 'selectors/common/userInfoSelector';

interface IFormDataAdapterStateProps {
    orderGender: GENDER_TYPE | null;
    passengers: TrainsPassengersCount;
    lastSegmentDeparture: string | undefined;
    lastSegmentArrival: string | undefined;
    userInfo: TUserInfo;
}

const formDataAdapterSelector = createStructuredSelector<
    StoreInterface,
    IFormDataAdapterStateProps
>({
    orderGender: orderGenderSelector,
    passengers: passengersCountSelector,
    lastSegmentDeparture: lastSegmentDepartureSelector,
    lastSegmentArrival: lastSegmentArrivalSelector,
    userInfo: getUserInfo,
});

export default formDataAdapterSelector;
