import _flatMap from 'lodash/flatMap';

import {EFormKey} from 'constants/form/EFormKey';

import {isNotNullable} from 'types/utilities';
import {
    ITrainsBookFormValues,
    IPassenger,
} from 'types/trains/booking/ITrainsBookFormValues';

import {TUserInfo} from 'reducers/common/commonReducerTypes';

import {saveBookingPassengers} from 'utilities/localStorage/booking/saveBookingPassengers';
import {saveBookingContacts} from 'utilities/localStorage/booking/saveBookingContacts';

export function saveFormInStorage(
    values: ITrainsBookFormValues,
    userInfo: TUserInfo,
): void {
    const formPassengers = _flatMap(values.passengers);

    if (values.contacts) {
        saveBookingContacts(EFormKey.TRAIN_BOOK, values.contacts, userInfo);
    }

    saveBookingPassengers<IPassenger>(
        EFormKey.TRAIN_BOOK,
        formPassengers.filter(isNotNullable),
        userInfo,
    );
}
