import _flatten from 'lodash/flatten';

import {BONUS_CARD_REGEXP} from 'projects/trains/constants/booking/validation/validationRules/common';

import {isNotNullable} from 'types/utilities';
import {
    IPassenger,
    ITrainsBookFormValues,
} from 'types/trains/booking/ITrainsBookFormValues';

import {flatMapPassengers} from 'projects/trains/lib/order/passengers/flatPassengers';

import * as i18nBlock from 'i18n/trains-order-fields-errors';

function getPassengerBonusCards(passenger: IPassenger): string[] {
    if (!passenger?.bonusCards) {
        return [];
    }

    return Object.values(passenger.bonusCards).filter(isNotNullable);
}

export function validateBonusCardDuplication(
    bonusCardValue: string | undefined,
    formValues: ITrainsBookFormValues,
): string | undefined {
    const cardRegExp = new RegExp(BONUS_CARD_REGEXP);

    if (
        !formValues.passengers ||
        !bonusCardValue ||
        !cardRegExp.test(bonusCardValue)
    ) {
        return undefined;
    }

    const bonusCards = flatMapPassengers(
        formValues.passengers,
        getPassengerBonusCards,
    ).filter(isNotNullable);

    return _flatten(bonusCards).filter(
        bonusCard => bonusCardValue === bonusCard,
    ).length > 1
        ? i18nBlock.duplicateDashBonusDashNumber()
        : undefined;
}
