import {IFieldError} from 'types/common/validation/form';

import {getStringError} from 'components/FormField/utilities/getValidationErrorMessage';

export function haveBonusCardError(
    errors?: string | IFieldError,
    submitErrors?: string | IFieldError,
): boolean {
    if (errors || submitErrors) {
        const blurError =
            getStringError(errors, false) ||
            getStringError(submitErrors, false);
        const submitError =
            getStringError(errors, true) || getStringError(submitErrors, true);
        const stringError = blurError || submitError;

        return Boolean(stringError?.length);
    }

    return false;
}
