import {PASSENGERS_TYPES} from 'projects/trains/constants/passengersTypes';

import {ITrainsCoachTariff} from 'reducers/trains/order/types';

/**
 * Поиск подходящего тарифа для пассажира.
 *
 * Копия функции getTariff из src/projects/trains/lib/order/tariffsInfo.ts
 * Оригинальная функция при вычистке экспа должна быть удалена
 *
 * @param ageGroup - возврасная категрия пассажира
 * @param age - возраст пассажира
 * @param tariffs - список тарифов в текущем вагоне
 */
export function getPassengerTariff(
    ageGroup: PASSENGERS_TYPES,
    age: number,
    tariffs: ITrainsCoachTariff[],
): ITrainsCoachTariff {
    return (
        tariffs.find(
            ({
                minAge,
                minAgeIncludesBirthday,
                maxAge,
                maxAgeIncludesBirthday,
                withoutPlace,
            }) =>
                (minAge < age || (minAgeIncludesBirthday && minAge === age)) &&
                (maxAge > age || (maxAgeIncludesBirthday && maxAge === age)) &&
                (ageGroup === PASSENGERS_TYPES.BABIES) === withoutPlace,
        ) || tariffs[tariffs.length - 1]
    );
}
