import React, {useContext, useEffect} from 'react';
import {useForm} from 'react-final-form';

import {PASSENGERS_TYPES} from 'projects/trains/constants/passengersTypes';

import {
    EFieldName as ETrainFields,
    ITrainsBookFormValues,
} from 'types/trains/booking/ITrainsBookFormValues';

import Form from 'components/Form/Form';

interface IPassengerDataAdapterProps {
    ageGroup: PASSENGERS_TYPES;
}

const PassengerDataAdapter: React.FC<IPassengerDataAdapterProps> = ({
    ageGroup,
}) => {
    const form = useForm<ITrainsBookFormValues>();
    const formGroupId = useContext(Form.FieldGroupContext);

    useEffect(() => {
        form.change(`${formGroupId}.${ETrainFields.ageGroup}` as any, ageGroup);
    }, [form, formGroupId, ageGroup]);

    return null;
};

export default PassengerDataAdapter;
