import {TRAINS_DOCUMENT_TYPES} from 'projects/trains/constants/documentTypes';
import {PASSENGERS_TYPES} from 'projects/trains/constants/passengersTypes';

import {makeCacheable} from 'projects/trains/lib/cache';
import {getAllowedDocumentTypes} from 'projects/trains/lib/order/passengers/documentTypes';

/**
 * Возвращает список доступных типов документов
 * @param ageGroup - возрастная группа пассажира
 * @param allowedDocumentTypes - массив допустимых документов для данного поезда
 * @return массив типов документов
 */
export const getDocumentList = makeCacheable(
    (
        ageGroup: PASSENGERS_TYPES,
        allowedDocumentTypes: TRAINS_DOCUMENT_TYPES[],
    ) =>
        getAllowedDocumentTypes(ageGroup, allowedDocumentTypes).map(item => ({
            value: item,
        })),
);
