import {PASSENGERS_TYPES} from 'projects/trains/constants/passengersTypes';

import {ITrainsTariffCategory} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';

import {getAgeGroup} from 'projects/trains/lib/order/fields/birthDate';
import {getBoardingAge} from 'utilities/dateUtils/getBoardingAge';

import * as i18nBlock from 'i18n/trains-order-fields-errors';

export function validateBirthdate(
    birthdateValue: string,
    ageGroup: PASSENGERS_TYPES,
    lastSegmentDeparture: string,
    tariffCategories: ITrainsTariffCategory[] | undefined,
): string | undefined {
    const boardingAgeGroup = getAgeGroup(
        getBoardingAge(birthdateValue, lastSegmentDeparture),
        tariffCategories,
    );

    if (!boardingAgeGroup) {
        return undefined;
    }

    switch (ageGroup) {
        case PASSENGERS_TYPES.BABIES: {
            if (boardingAgeGroup !== PASSENGERS_TYPES.BABIES) {
                return i18nBlock.isDashInvalidDashTariffDashAge();
            }

            break;
        }

        case PASSENGERS_TYPES.CHILDREN: {
            if (
                ![PASSENGERS_TYPES.BABIES, PASSENGERS_TYPES.CHILDREN].includes(
                    boardingAgeGroup,
                )
            ) {
                return i18nBlock.isDashInvalidDashTariffDashAge();
            }
        }
    }

    return undefined;
}
