import {PASSENGERS_TYPES} from 'projects/trains/constants/passengersTypes';
import {
    GENDER_TYPE,
    MALE_AND_FEMALE_GENDER_TYPES,
} from 'projects/trains/constants/genders';

import {IPassengerWithDocumentsAndBonusCardsDTO} from 'server/api/TravelersApi/types/IPassengerDTO';
import {ITrainsTariffCategory} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';

import {getBoardingAgeGroup} from 'projects/trains/lib/order/fields/birthDate';
import {HUMAN_DATE_RU, ROBOT} from 'utilities/dateUtils/formats';
import {parseDate} from 'utilities/dateUtils';

function isSameAgeGroup(
    ageGroup: PASSENGERS_TYPES,
    passengerAgeGroup: PASSENGERS_TYPES | null,
): boolean {
    if (!passengerAgeGroup) {
        return true;
    }

    return passengerAgeGroup === ageGroup;
}

function isSameGender(
    passenger: IPassengerWithDocumentsAndBonusCardsDTO,
    gender: GENDER_TYPE | null,
    passengerAgeGroup: PASSENGERS_TYPES | null,
): boolean {
    if (
        gender &&
        passenger.gender &&
        MALE_AND_FEMALE_GENDER_TYPES.includes(gender) &&
        passengerAgeGroup &&
        passengerAgeGroup === PASSENGERS_TYPES.ADULTS
    ) {
        return gender === (passenger.gender as string);
    }

    return true;
}

export default function getFilteredAccountPassengers(
    passengers: IPassengerWithDocumentsAndBonusCardsDTO[],
    ageGroup: PASSENGERS_TYPES,
    gender: GENDER_TYPE | null,
    lastSegmentDeparture: string,
    tariffCategories: ITrainsTariffCategory[],
): IPassengerWithDocumentsAndBonusCardsDTO[] {
    return passengers?.filter(passenger => {
        const passengerAgeGroup = passenger.birth_date
            ? getBoardingAgeGroup(
                  parseDate(passenger.birth_date, ROBOT).format(HUMAN_DATE_RU),
                  lastSegmentDeparture,
                  tariffCategories,
              )
            : null;

        return (
            isSameAgeGroup(ageGroup, passengerAgeGroup) &&
            isSameGender(passenger, gender, passengerAgeGroup)
        );
    });
}
