import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';

import * as i18n from 'i18n/trains-train-details';

export default function getChooseServiceClassTitle(
    type: TRAIN_COACH_TYPE,
): string | null {
    switch (type) {
        case TRAIN_COACH_TYPE.PLATZKARTE:
            return i18n.chooseDashPlatzkarteDashClass();
        case TRAIN_COACH_TYPE.COMPARTMENT:
            return i18n.chooseDashCompartmentDashClass();
        case TRAIN_COACH_TYPE.SUITE:
            return i18n.chooseDashSuiteDashClass();
        case TRAIN_COACH_TYPE.COMMON:
            return i18n.chooseDashCommonDashClass();
        case TRAIN_COACH_TYPE.SITTING:
            return i18n.chooseDashSittingDashClass();
        case TRAIN_COACH_TYPE.SOFT:
            return null;
    }
}
