import {ITrainsDirectionAndIndex} from 'types/trains/common/segment/ITrainsDirectionAndIndex';
import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';
import {EDirection} from 'types/common/EDirection';

type TGoals =
    | ETrainsGoal.ORDER_FORWARD_FIRST_PLACES_PAGE_LOAD
    | ETrainsGoal.ORDER_FORWARD_SECOND_PLACES_PAGE_LOAD
    | ETrainsGoal.ORDER_BACKWARD_FIRST_PLACES_PAGE_LOAD;

export default function getGoalByDirectionAndIndex({
    direction,
    index,
}: ITrainsDirectionAndIndex): TGoals | undefined {
    if (direction === EDirection.FORWARD) {
        switch (index) {
            case 0:
                return ETrainsGoal.ORDER_FORWARD_FIRST_PLACES_PAGE_LOAD;
            case 1:
                return ETrainsGoal.ORDER_FORWARD_SECOND_PLACES_PAGE_LOAD;

            default:
                return;
        }
    }

    if (index === 0) {
        return ETrainsGoal.ORDER_BACKWARD_FIRST_PLACES_PAGE_LOAD;
    }
}
