import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';

import * as i18n from 'i18n/trains-train-details';

export default function getNoChooseServiceClassTitle(
    type: TRAIN_COACH_TYPE,
): string | null {
    switch (type) {
        case TRAIN_COACH_TYPE.PLATZKARTE:
            return i18n.noDashChoiceDashPlatzkarteDashClass();
        case TRAIN_COACH_TYPE.COMPARTMENT:
            return i18n.noDashChoiceDashCompartmentDashClass();
        case TRAIN_COACH_TYPE.SUITE:
            return i18n.noDashChoiceDashSuiteDashClass();
        case TRAIN_COACH_TYPE.COMMON:
            return i18n.noDashChoiceDashCommonDashClass();
        case TRAIN_COACH_TYPE.SITTING:
            return i18n.noDashChoiceDashSittingDashClass();
        case TRAIN_COACH_TYPE.SOFT:
            return null;
    }
}
