import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import IPrice from 'utilities/currency/PriceInterface';

import Price from 'components/Price/Price';

interface IPriceItemProps extends IWithClassName, IWithQaAttributes {
    title: string;
    price: IPrice | undefined;
}

const PriceItem: React.FC<IPriceItemProps> = props => {
    const {className, title, price} = props;

    return (
        <div className={className} {...prepareQaAttributes(props)}>
            {title}
            {price && (
                <Price
                    {...price}
                    {...prepareQaAttributes({parent: props, current: 'price'})}
                />
            )}
        </div>
    );
};

export default PriceItem;
