import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {ITrainsCoach} from 'reducers/trains/order/types';
import {
    IPriceDivision,
    IPriceDivisionWithTheme,
} from 'projects/trains/lib/order/priceScale/types';
import {EPricePalette} from 'types/trains/booking/EPricePalette';

import {CurrencyType} from 'utilities/currency/CurrencyType';

import * as i18nBlock from 'i18n/trains-common';

import Price from 'components/Price/Price';
import PriceRange from 'projects/trains/components/TrainsOrderPage/PriceRange/PriceRange';

import cx from './PriceLegend.scss';

interface IPriceLegendProps extends IWithClassName {
    coach: ITrainsCoach;
    prices: (IPriceDivision | IPriceDivisionWithTheme)[];
}

const PriceLegend: React.FC<IPriceLegendProps> = props => {
    const {className, coach, prices} = props;

    const {schemaId} = coach;

    if (!prices.length) {
        return null;
    }

    return (
        <div className={cx('root', className)}>
            {prices.map(({values, theme}) => {
                // нет смысла раскрашивать легенду если нет схемы
                const mods =
                    schemaId && theme
                        ? {
                              description_styled: true,
                              description_theme_cheapestPrice:
                                  theme === EPricePalette.CHEAPEST_PRICE_THEME,
                              description_theme_goodPrice:
                                  theme === EPricePalette.GOOD_PRICE_THEME,
                              description_theme_averagePrice:
                                  theme === EPricePalette.AVERAGE_PRICE_THEME,
                              description_theme_upperAveragePrice:
                                  theme ===
                                  EPricePalette.UPPER_AVERAGE_PRICE_THEME,
                              description_theme_mostExpensivePrice:
                                  theme ===
                                  EPricePalette.MOST_EXPENSIVE_PRICE_THEME,
                          }
                        : {};

                return (
                    <span key={values[0]} className={cx('legendItem')}>
                        <span className={cx('description', mods)}>
                            {i18nBlock.placeDashPrice()}
                        </span>

                        <span className={cx('item')}>
                            {values.length > 1 ? (
                                <PriceRange
                                    values={values}
                                    currency={CurrencyType.RUR}
                                />
                            ) : (
                                <Price
                                    value={values[0]}
                                    currency={CurrencyType.RUR}
                                    isRound
                                />
                            )}
                        </span>
                    </span>
                );
            })}
        </div>
    );
};

export default PriceLegend;
