import React from 'react';

import {CurrencyType} from 'utilities/currency/CurrencyType';
import {CHAR_NBSP, CHAR_DASH} from 'utilities/strings/charCodes';

import Price from 'components/Price/Price';

interface IPriceRangeProps {
    values: number[];
    currency: CurrencyType;
}

const PriceRange: React.FC<IPriceRangeProps> = props => {
    const {values, currency} = props;

    if (!values.length) {
        return null;
    }

    return (
        <span>
            <Price value={Math.min(...values)} currency={currency} isRound />

            {`${CHAR_NBSP}${CHAR_DASH}${CHAR_NBSP}`}

            <Price value={Math.max(...values)} currency={currency} isRound />
        </span>
    );
};

export default PriceRange;
