import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';

import * as i18nBlock from 'i18n/trains-place-categories';

export default function getTextForPlaceType(
    coachType: TRAIN_COACH_TYPE,
    placeTypeArray: [number, number],
): string {
    const [first, second] = placeTypeArray;
    const isSittingCoach = coachType === TRAIN_COACH_TYPE.SITTING;

    const firstOption = i18nBlock
        .placementDashTypeDashFirst({count: first, isSittingCoach})
        .trim();
    const secondOption = i18nBlock
        .placementDashTypeDashSecond({count: second, isSittingCoach})
        .trim();

    if (first === 0) {
        return secondOption;
    } else if (second === 0) {
        return firstOption;
    }

    return `${firstOption}, ${secondOption}`;
}
