import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';

import {ITrainsCoach, ITrainsRequirements} from 'reducers/trains/order/types';
import {ITrainsSchema} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';

import isUpperAndBottomCountsOptionAvailable from 'projects/trains/components/TrainsOrderPage/Requirements/helpers/isUpperAndBottomCountsOptionAvailable';
import isNearWindowAndPassageCountsOptionAvailable from 'projects/trains/components/TrainsOrderPage/Requirements/helpers/isNearWindowAndPassageCountsOptionAvailable';

/**
 * Функция возвращает, доступна ли опция расположения с количеством разных типов мест
 *
 * @param option - значение опции
 * @param coaches - вагоны
 * @param schemas - схемы
 * @param passengersCount - количество пассажиров
 * @param coachType - тип вагона
 * @param requirements - требования к местам
 */
export default function isArrangementCountOptionAvailable({
    option,
    coaches,
    schemas,
    passengersCount,
    coachType,
    requirements,
}: {
    option: [number, number];
    coaches: ITrainsCoach[];
    schemas: Record<number, ITrainsSchema>;
    passengersCount: number;
    coachType: TRAIN_COACH_TYPE;
    requirements: ITrainsRequirements;
}): boolean {
    if (
        coachType === TRAIN_COACH_TYPE.COMPARTMENT ||
        coachType === TRAIN_COACH_TYPE.PLATZKARTE
    ) {
        return isUpperAndBottomCountsOptionAvailable({
            option,
            coaches,
            schemas,
            passengersCount,
            coachType,
            requirements,
        });
    }

    return isNearWindowAndPassageCountsOptionAvailable({
        option,
        coaches,
        schemas,
        passengersCount,
        coachType,
        requirements,
    });
}
