import React, {useCallback} from 'react';

import {IWithClassName} from 'types/withClassName';
import {ITrainsCoach, ITrainsDetails} from 'reducers/trains/order/types';
import {TTrainsStoreOrderSegment} from 'projects/trains/lib/segments/types';

import CoachHeader from 'projects/trains/components/TrainsOrderPage/Coach/components/CoachHeader/CoachHeader';

import cx from './CoachSelectorItem.scss';

interface ICoachSelectorItemProps extends IWithClassName {
    coach: ITrainsCoach;
    segment: TTrainsStoreOrderSegment | null;
    trainDetails: ITrainsDetails | null;
    showCoachArrival: boolean;
    onClick(coach: ITrainsCoach): void;
}

const CoachSelectorItem: React.FC<ICoachSelectorItemProps> = props => {
    const {coach, segment, className, trainDetails, showCoachArrival, onClick} =
        props;

    const handleClick = useCallback(() => {
        onClick(coach);
    }, [onClick, coach]);

    if (!segment || !trainDetails) {
        return null;
    }

    return (
        <button
            className={cx('root', className)}
            type="button"
            onClick={handleClick}
        >
            <CoachHeader
                className={cx('coachHeader')}
                coach={coach}
                showNFCoach={trainDetails.isFirm && !coach.isFirm}
                showCoachArrival={showCoachArrival}
            />
        </button>
    );
};

export default CoachSelectorItem;
