import React from 'react';

import {GENDER_TYPE} from 'projects/trains/constants/genders';

import {ITrainsCoach, TrainsPassengersCount} from 'reducers/trains/order/types';
import {IWithClassName} from 'types/withClassName';

import getAvailableForSelectGendersForCoaches from 'projects/trains/lib/order/gender/getAvailableForSelectGendersForCoaches';

import GenderSelector from 'projects/trains/components/TrainsOrderPage/GenderSelector/GenderSelector';

import cx from './GenderRequirement.scss';

interface IGenderRequirementProps extends IWithClassName {
    value: GENDER_TYPE | null;
    coaches: ITrainsCoach[];
    passengers: TrainsPassengersCount;
}

const GenderRequirement: React.FC<IGenderRequirementProps> = props => {
    const {value, coaches, passengers, className} = props;

    const availableForSelectGenders = getAvailableForSelectGendersForCoaches(
        coaches,
        passengers,
    );

    if (availableForSelectGenders.length <= 1) {
        return null;
    }

    return (
        <GenderSelector
            className={cx('root', className)}
            value={value || undefined}
            genders={availableForSelectGenders}
        />
    );
};

export default GenderRequirement;
