import {ARRANGEMENT_REQUIREMENTS} from 'projects/trains/constants/requirements';

import * as i18nBlock from 'i18n/trains-place-categories';

export default function getArrangementRequirements(
    requirement: ARRANGEMENT_REQUIREMENTS,
): string {
    switch (requirement) {
        case ARRANGEMENT_REQUIREMENTS.COMPARTMENT:
            return i18nBlock.requirementDashCompartment();
        case ARRANGEMENT_REQUIREMENTS.NEAREST:
            return '';
        case ARRANGEMENT_REQUIREMENTS.SECTION:
            return i18nBlock.requirementDashSection();
        case ARRANGEMENT_REQUIREMENTS.NOT_SIDE:
            return i18nBlock.requirementDashNotSide();
        case ARRANGEMENT_REQUIREMENTS.IRRELEVANT:
            return i18nBlock.requirementDashIrrelevant();
    }
}
