import {ITrainsCoach} from 'reducers/trains/order/types';
import {ITrainsSchema} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';
import {isNotNull} from 'types/utilities';

import getPlacesTypesAndCountsWithDirectionsByCoaches from 'projects/trains/components/TrainsOrderPage/Requirements/SapsanRequirements/helpers/getPlacesTypesAndCountsWithDirectionsByCoaches';
import {
    SAPSAN_NEAR_WINDOW,
    SAPSAN_NEAR_WINDOW_IN_ROW,
} from 'projects/trains/lib/order/placesTypes';

/**
 * Функция возвращает доступные варианты для селектора типа мест Сапсанов
 *
 * @param coaches - вагоны
 * @param schemas - схемы
 * @param passengersCount - количество пассажиров
 * @param isForward - нужны ли места по направлению движения
 */
export default function getAvailableOptionTypes({
    coaches,
    schemas,
    passengersCount,
    isForward,
}: {
    coaches: ITrainsCoach[];
    schemas: Record<number, ITrainsSchema>;
    passengersCount: number;
    isForward: boolean;
}): string[] {
    return Object.entries(
        getPlacesTypesAndCountsWithDirectionsByCoaches(coaches, schemas),
    )
        .map(([placeType, placesCountsWithDirections]) => {
            if (placeType === SAPSAN_NEAR_WINDOW_IN_ROW || !isForward) {
                if (
                    placesCountsWithDirections.forward +
                        placesCountsWithDirections.backward >=
                    passengersCount
                ) {
                    return placeType;
                }

                return null;
            }

            if (
                isForward &&
                placesCountsWithDirections.maxForwardPlaces >= passengersCount
            ) {
                return placeType;
            }

            return null;
        })
        .filter(
            optionType =>
                optionType &&
                optionType !==
                    (passengersCount > 1
                        ? SAPSAN_NEAR_WINDOW
                        : SAPSAN_NEAR_WINDOW_IN_ROW),
        )
        .filter(isNotNull);
}
