import {REQUIREMENTS_IRRELEVANT_OPTION} from 'projects/trains/constants/requirements';

import {ITrainsCoachPlace} from 'server/services/TrainsService/types/ITrainsDetailsInfoServiceResponse';
import {
    ITrainsSchema,
    TrainPlaceType,
} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';

import isNearWindowPlace from 'projects/trains/components/TrainsOrderPage/Requirements/SapsanRequirements/helpers/isNearWindowPlace';
import getNearWindowInRowPlacesWithDirections from 'projects/trains/components/TrainsOrderPage/Requirements/SapsanRequirements/helpers/getNearWindowInRowPlacesWithDirections';
import {
    SAPSAN_NEAR_TABLE,
    SAPSAN_NEAR_WINDOW,
    SAPSAN_NEAR_WINDOW_IN_ROW,
    SAPSAN_NO_TABLE,
    SAPSAN_SINGLE,
} from 'projects/trains/lib/order/placesTypes';

function getInitPlacesTypesAndCountsWithDirections(): Record<
    string,
    {forward: number; backward: number}
> {
    return {
        [REQUIREMENTS_IRRELEVANT_OPTION]: {
            forward: 0,
            backward: 0,
        },
        [SAPSAN_NEAR_WINDOW]: {
            forward: 0,
            backward: 0,
        },
        [SAPSAN_NEAR_WINDOW_IN_ROW]: {
            forward: 0,
            backward: 0,
        },
        [SAPSAN_NEAR_TABLE]: {
            forward: 0,
            backward: 0,
        },
        [SAPSAN_NO_TABLE]: {
            forward: 0,
            backward: 0,
        },
        [SAPSAN_SINGLE]: {
            forward: 0,
            backward: 0,
        },
    };
}

function increaseDirectionCounts(
    placesTypesAndCountsWithDirection: Record<
        string,
        {forward: number; backward: number}
    >,
    type: string,
    isForward: boolean,
): void {
    if (isForward) {
        placesTypesAndCountsWithDirection[type].forward++;
    } else {
        placesTypesAndCountsWithDirection[type].backward++;
    }
}

/**
 * Функция для Сапсанов для каждого типа мест возвращает количество мест с разделением по направлению.
 *
 * @param places - места
 * @param schema - схема
 */
export default function getPlacesTypesAndCountsWithDirections(
    places: ITrainsCoachPlace[],
    schema: ITrainsSchema | null,
): Record<string, {forward: number; backward: number}> {
    const placesTypesAndCountsWithDirection = places.reduce<
        Record<string, {forward: number; backward: number}>
    >((placesTypesAndCountsWithDirectionAcc, {type, number}) => {
        if (!type) {
            return placesTypesAndCountsWithDirectionAcc;
        }

        const isForward = type.indexOf('Forward') !== -1;

        increaseDirectionCounts(
            placesTypesAndCountsWithDirectionAcc,
            REQUIREMENTS_IRRELEVANT_OPTION,
            isForward,
        );

        if (type === TrainPlaceType.SINGLE_FORWARD) {
            placesTypesAndCountsWithDirectionAcc[SAPSAN_SINGLE].forward++;

            return placesTypesAndCountsWithDirectionAcc;
        }

        if (isNearWindowPlace(number, type)) {
            increaseDirectionCounts(
                placesTypesAndCountsWithDirectionAcc,
                SAPSAN_NEAR_WINDOW,
                isForward,
            );
        }

        if (
            type === TrainPlaceType.NEAR_TABLE_FORWARD ||
            type === TrainPlaceType.NEAR_TABLE_BACKWARD
        ) {
            increaseDirectionCounts(
                placesTypesAndCountsWithDirectionAcc,
                SAPSAN_NEAR_TABLE,
                isForward,
            );
        } else {
            increaseDirectionCounts(
                placesTypesAndCountsWithDirectionAcc,
                SAPSAN_NO_TABLE,
                isForward,
            );
        }

        return placesTypesAndCountsWithDirectionAcc;
    }, getInitPlacesTypesAndCountsWithDirections());

    placesTypesAndCountsWithDirection[SAPSAN_NEAR_WINDOW_IN_ROW] =
        getNearWindowInRowPlacesWithDirections(places, schema);

    return placesTypesAndCountsWithDirection;
}
