import {TrainPlaceType} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';

/**
 * Функция возвращает признак того, находится ли место у окна
 * Нечетные места находятся у окна, кроме TrainPlaceType.NO_WINDOW_FORWARD и TrainPlaceType.NO_WINDOW_BACKWARD
 *
 * @param number - номер места
 * @param type - тип места
 */
export default function isNearWindowPlace(
    number: number,
    type: TrainPlaceType,
): boolean {
    return (
        number % 2 === 1 &&
        type !== TrainPlaceType.NO_WINDOW_FORWARD &&
        type !== TrainPlaceType.NO_WINDOW_BACKWARD
    );
}
