import {ITrainsCoachPlace} from 'server/services/TrainsService/types/ITrainsDetailsInfoServiceResponse';

/**
 * Функция для мест возвращает количество мест у окна и у прохода.
 *
 * @param placeMap - карта мест
 * @param placesNumbers - номера мест для подсчета
 * @param coachNearWindowPlaces - номера мест у окна
 */
export default function getNearWindowAndPassagePlacesCounts(
    placeMap: PartialRecord<number, ITrainsCoachPlace>,
    placesNumbers: number[],
    coachNearWindowPlaces: number[],
): {nearWindow: number; nearPassage: number} {
    return placesNumbers.reduce<{nearWindow: number; nearPassage: number}>(
        (placesByType, placeNumber) => {
            if (!placeMap[placeNumber]) {
                return placesByType;
            }

            if (coachNearWindowPlaces.includes(placeNumber)) {
                placesByType.nearWindow++;
            } else {
                placesByType.nearPassage++;
            }

            return placesByType;
        },
        {
            nearWindow: 0,
            nearPassage: 0,
        },
    );
}
