import difference from 'lodash/difference';

import {ARRANGEMENT_REQUIREMENTS} from 'projects/trains/constants/requirements';
import {
    COMPARTMENT,
    PLATZKARTE,
    SITTING,
} from 'projects/trains/lib/segments/tariffs/constants';
import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';

import {ISchemaPlaceFlags} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';
import {ITrainsCoach} from 'reducers/trains/order/types';

/**
 * Функция возвращает сгруппированные места для проверки доступности некоторых требований к местам
 *
 * @param placesType - тип мест
 * @param coachType - тип вагона
 * @param placeFlags - информация о местах из админки
 * @param coach - вагон
 */
export default function getPlacesGroupedByBlocks({
    placesType,
    coachType,
    placeFlags,
    coach,
}: {
    placesType?: ARRANGEMENT_REQUIREMENTS;
    coachType: TRAIN_COACH_TYPE;
    placeFlags: ISchemaPlaceFlags;
    coach: ITrainsCoach;
}): number[][] {
    if (coachType === PLATZKARTE || coachType === COMPARTMENT) {
        if (placesType === ARRANGEMENT_REQUIREMENTS.COMPARTMENT) {
            return placeFlags.compartments;
        }

        if (placesType === ARRANGEMENT_REQUIREMENTS.SECTION) {
            return placeFlags.sections;
        }

        if (placesType === ARRANGEMENT_REQUIREMENTS.NOT_SIDE) {
            return [
                difference(
                    coach.places.map(({number}) => number),
                    placeFlags.side,
                ),
            ];
        }
    }

    if (coachType === SITTING) {
        if (placesType === ARRANGEMENT_REQUIREMENTS.NEAREST) {
            return placeFlags.groupsInRows;
        }
    }

    return [coach.places.map(({number}) => number)];
}
