import {ITrainsCoachPlace} from 'server/services/TrainsService/types/ITrainsDetailsInfoServiceResponse';

/**
 * Функция для мест возвращает количество верхних и нижних мест.
 *
 * @param placeMap - карта мест
 * @param placesNumbers - номера мест, которые надо использовать в подсчете
 * @param coachUpperPlaces - номера верхних мест
 */
export default function getUpperAndBottomPlacesCounts(
    placeMap: PartialRecord<number, ITrainsCoachPlace>,
    placesNumbers: number[],
    coachUpperPlaces: number[],
): {upper: number; bottom: number} {
    return placesNumbers.reduce<{upper: number; bottom: number}>(
        (placesByType, placeNumber) => {
            if (!placeMap[placeNumber]) {
                return placesByType;
            }

            if (coachUpperPlaces.includes(placeNumber)) {
                placesByType.upper++;
            } else {
                placesByType.bottom++;
            }

            return placesByType;
        },
        {
            upper: 0,
            bottom: 0,
        },
    );
}
