import {ITrainsCoach} from 'reducers/trains/order/types';

import areAllCoachesThroughAndWithSameArrivalTime from 'projects/trains/lib/order/coaches/areAllCoachesThroughAndWithSameArrivalTime';

/**
 * Функция определяет, нужно ли отображать селект с выбором номера вагона в требованиях к местам жд бронирования.
 *
 * Селект нужно отображать в случаях, когда в одном классе вагонов есть беспересадочные вагоны (у них отличается время прибытия).
 */
export default function needToShowTrainsCoachNumberRequirement(
    coaches: ITrainsCoach[],
): boolean {
    return (
        coaches.length > 1 &&
        coaches.some(item => item.throughArrival) &&
        !areAllCoachesThroughAndWithSameArrivalTime(coaches)
    );
}
