import React from 'react';

import {IPlaceMapItem} from 'projects/trains/lib/order/getPlaceMap';

import {ISchemaPlaceCoords} from 'projects/trains/components/TrainsOrderPage/SvgSchema/SvgSchema';

const TOOLTIP_HEIGHT = 27;
const TOOLTIP_MARGIN = 9;

/**
 * Функция для расчета координат тултипа
 *
 * @param place - место
 * @param coords - координаты svg элемента соответствующего месту
 */
export function getOffset(
    place: IPlaceMapItem,
    coords: ISchemaPlaceCoords,
): Pick<React.CSSProperties, 'top' | 'left'> {
    const dy = place.upper
        ? -TOOLTIP_HEIGHT - TOOLTIP_MARGIN
        : coords.height + TOOLTIP_MARGIN;
    const dx = Math.round(coords.width / 2);

    return {
        top: coords.top + dy,
        left: coords.left + dx,
    };
}
