import {IPlaceMapItem} from 'projects/trains/lib/order/getPlaceMap';
import {SELECTED} from 'projects/trains/lib/order/placeMap';

/**
 * Возвращает отсортированный список с номерами выбранных мест
 */
export function getSelectedPlaceNumbers(placeMap: IPlaceMapItem[]): number[] {
    return placeMap
        .filter(item => item.placeState === SELECTED)
        .map(item => item.number)
        .sort((a, c) => a - c);
}
