import React from 'react';

import {IPlaceMapItem} from 'projects/trains/lib/order/getPlaceMap';
import {
    AVAILABLE,
    SELECTED,
    UNAVAILABLE,
} from 'projects/trains/lib/order/placeMap';
import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';
import getBadPlaceStateText from 'projects/trains/components/TrainsOrderPage/SchemeTooltip/utilities/getBadPlaceStateText';
import {getSelectedPlaceNumbers} from 'projects/trains/components/TrainsOrderPage/SchemeTooltip/utilities/getSelectedPlaceNumbers';

import * as i18nBlock from 'i18n/trains-transport-schema';

import Price from 'components/Price/Price';

interface IGetTooltipTextParams {
    place: IPlaceMapItem;
    passengersCount: number;
    placeMap: IPlaceMapItem[];
}

export default function getTooltipText({
    place,
    passengersCount,
    placeMap,
}: IGetTooltipTextParams): React.ReactNode {
    const {placeState, upper, tariff} = place;

    if ((placeState === AVAILABLE || placeState === SELECTED) && tariff) {
        /**
         * Пока показываем подсказки только для ярусных вагонов (верхнее/нижнее)
         */
        return insertJSXIntoKey(i18nBlock.placeDashTypeDashWithDashPrice)({
            type: upper
                ? i18nBlock.placeDashUpper()
                : i18nBlock.placeDashLower(),
            price: (
                <Price
                    value={tariff.value}
                    currency={tariff.currency}
                    isRound
                />
            ),
        });
    }

    if (placeState === UNAVAILABLE && passengersCount > 1) {
        const selectedPlaceNumbers = getSelectedPlaceNumbers(placeMap);
        const selectedPlaceCount = selectedPlaceNumbers.length;

        if (passengersCount === selectedPlaceCount) {
            return i18nBlock.placeDashUnavailableDashFull();
        }

        if (selectedPlaceCount > 0) {
            const seats = selectedPlaceNumbers.join(', ');

            return selectedPlaceCount > 1
                ? i18nBlock.placeDashUnavailableDashMultiple({seats})
                : i18nBlock.placeDashUnavailableDashSingle({
                      seat: seats,
                  });
        }

        return i18nBlock.placeDashUnavailable();
    }

    return getBadPlaceStateText(placeState);
}
