import {ITrainsSchema} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';

import {IPlaceMapItem} from 'projects/trains/lib/order/getPlaceMap';
import {AVAILABLE, SELECTED} from 'projects/trains/lib/order/placeMap';
import {isStoreysCoach} from 'projects/trains/lib/order/placeCategories';

export const isTooltipAvailable = (
    place: IPlaceMapItem,
    schema: ITrainsSchema,
): boolean => {
    const {placeState} = place;

    if (placeState === AVAILABLE || placeState === SELECTED) {
        return !schema.hidePlaceNumbers && isStoreysCoach(schema);
    }

    return true;
};
