import {FC, RefObject, useMemo} from 'react';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nBlock from 'i18n/trains-coach-disable-tab-info';

import Box from 'components/Box/Box';
import Text from 'components/Text/Text';
import Flex from 'components/Flex/Flex';
import {IMessageBoxPopupProps} from 'components/MessageBoxPopup/MessageBoxPopup';
import MessageBoxPopupOrBottomSheet from 'components/MessageBoxPopupOrBottomSheet/MessageBoxPopupOrBottomSheet';

import cx from './CoachDisableTabPopupOrBottomSheet.scss';

interface ICoachDisableTabPopupOrBottomSheetProps {
    isVisible: boolean;
    boundaryRef: RefObject<HTMLElement>;
    anchorRef?: RefObject<HTMLElement>;
    onClose: () => void;
}

const CoachDisableTabPopupOrBottomSheet: FC<ICoachDisableTabPopupOrBottomSheetProps> =
    props => {
        const {isVisible, boundaryRef, anchorRef, onClose} = props;
        const deviceType = useDeviceType();
        const {isDesktop} = deviceType;

        const messageBoxProps = useMemo<
            Omit<IMessageBoxPopupProps, 'isVisible'>
        >(
            () => ({
                anchorRef: anchorRef ?? {current: null},
                boundaryRef,
                hasClose: true,
                closeOnScroll: false,
            }),
            [boundaryRef, anchorRef],
        );

        return (
            <MessageBoxPopupOrBottomSheet
                isVisible={isVisible}
                messageBoxProps={messageBoxProps}
                onClose={onClose}
            >
                {isDesktop ? (
                    <Box
                        className={cx(deviceMods('content', deviceType))}
                        x="6"
                        y="6"
                    >
                        <Text size="s" color="inverse">
                            {i18nBlock.description()}
                        </Text>
                    </Box>
                ) : (
                    <Flex between={4} flexDirection="column">
                        <Text
                            tag="div"
                            size="l"
                            weight="medium"
                            color="primary"
                        >
                            {i18nBlock.title()}
                        </Text>
                        <Text tag="div" size="s" color="primary">
                            {i18nBlock.description()}
                        </Text>
                    </Flex>
                )}
            </MessageBoxPopupOrBottomSheet>
        );
    };

export default CoachDisableTabPopupOrBottomSheet;
