import {
    useCallback,
    FC,
    useContext,
    useEffect,
    MutableRefObject,
    useRef,
} from 'react';

import {useBoolean} from 'utilities/hooks/useBoolean';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import {PlacesStepScopeRefContext} from 'projects/trains/components/TrainsOrderPage/PlacesStep/contexts/PlacesStepScopeRefContext';

import CoachTypeButton, {
    ICoachTypeButtonProps,
} from '../CoachTypeButton/CoachTypeButton';
import CoachDisableTabPopupOrBottomSheet from '../CoachDisableTabPopupOrBottomSheet/CoachDisableTabPopupOrBottomSheet';

interface ICoachTypeButtonWithDisableInfoProps
    extends ICoachTypeButtonProps,
        IWithQaAttributes {
    buttonRef: MutableRefObject<HTMLButtonElement>;
}

const CoachTypeButtonWithDisableInfo: FC<ICoachTypeButtonWithDisableInfoProps> =
    props => {
        const {
            price,
            value,
            title,
            active,
            onClick,
            disabled,
            size,
            buttonRef,
            hasDiscount,
        } = props;
        const {
            value: isVisible,
            toggle: toggleVisibility,
            setFalse: handleClose,
        } = useBoolean(false);

        const anchorRef = useRef<HTMLButtonElement>(null);

        useEffect(() => {
            if (buttonRef && anchorRef.current) {
                buttonRef.current = anchorRef.current;
            }
        }, [buttonRef]);

        const boundaryRef = useContext(PlacesStepScopeRefContext);
        const handleClick = useCallback(() => {
            if (disabled) {
                toggleVisibility();
            } else {
                onClick();
            }
        }, [onClick, toggleVisibility, disabled]);

        return (
            <>
                <CoachTypeButton
                    ref={anchorRef}
                    size={size}
                    price={price}
                    title={title}
                    value={value}
                    active={active}
                    disabled={disabled}
                    onClick={handleClick}
                    hasDiscount={hasDiscount}
                    {...prepareQaAttributes(props)}
                />
                <CoachDisableTabPopupOrBottomSheet
                    isVisible={isVisible}
                    anchorRef={anchorRef}
                    boundaryRef={boundaryRef}
                    onClose={handleClose}
                />
            </>
        );
    };

export default CoachTypeButtonWithDisableInfo;
