import {FC, MutableRefObject, useMemo, useCallback} from 'react';

import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
    prepareCustomQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import {
    ICoachTypeButton,
    TCoachTypeButtonSize,
} from 'projects/trains/components/TrainsOrderPage/SimpleSelectorView/components/CoachTypeButton/CoachTypeButton';
import Tabs from 'components/Tabs/Tabs';

import CoachTypeButtonWithDisableInfo from '../CoachTypeButtonWithDisableInfo/CoachTypeButtonWithDisableInfo';

import cx from './CoachTypeSelector.scss';

interface ICoachTypeSelectorProps extends IWithClassName, IWithQaAttributes {
    options: ICoachTypeButton[];
    size?: TCoachTypeButtonSize;
    value?: TRAIN_COACH_TYPE | string;
    onChange(value: TRAIN_COACH_TYPE | string): void;
}

const CoachTypeSelector: FC<ICoachTypeSelectorProps> = props => {
    const {className, options, size, value, onChange} = props;
    const tabs = useMemo(() => options.map(item => item.value), [options]);
    const getTabId = useCallback(tab => tab, []);
    const renderTab = useCallback(
        ({tab, tabProps}) => {
            const {active, innerRef, onClick} = tabProps;
            const option = options.find(item => item.value === tab);

            if (!option || !onClick) {
                return null;
            }

            return (
                <CoachTypeButtonWithDisableInfo
                    size={size}
                    key={option.value}
                    value={option.value}
                    title={option.title}
                    price={option.price}
                    hasDiscount={option.hasDiscount}
                    active={active}
                    disabled={option.disabled}
                    buttonRef={innerRef as MutableRefObject<HTMLButtonElement>}
                    onClick={onClick}
                    {...prepareCustomQaAttributes(
                        'data-active',
                        String(active),
                    )}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'tabButton',
                        key: option.value,
                    })}
                />
            );
        },
        [options, size],
    );

    return (
        <Tabs<string, string>
            className={className}
            scrollableClassName={cx('content')}
            between={2}
            offset={4}
            activeTabId={value}
            tabs={tabs}
            getTabId={getTabId}
            renderTab={renderTab}
            onChange={onChange}
            {...prepareQaAttributes(props)}
        />
    );
};

export default CoachTypeSelector;
