import {useEffect} from 'react';
import {useDispatch} from 'react-redux';

import {
    isTrainsCoachType,
    TRAIN_COACH_TYPE,
} from 'projects/trains/constants/coachType';

import {ICoachesTypeGroup} from 'projects/trains/components/TrainsOrderPage/SimpleSelectorView/types/TCoachesTypeGroups';

import {changeCoachType} from 'reducers/trains/order/thunk/changeCoachType';

import {ITrainsTabsOption} from 'projects/trains/components/TrainsOrderPage/SimpleSelectorView/utilities/calculateCoachTabsOptions';

export interface IUseChangeActiveGroupProps {
    options: ITrainsTabsOption[];
    activeGroup?: ICoachesTypeGroup | null;
    handleClassChange: (value: string) => void;
    handleTypeChange: (value: TRAIN_COACH_TYPE) => void;
    selectorValue?: TRAIN_COACH_TYPE | string;
    trainsDefaultActiveTab?: boolean;
}

export const useChangeActiveGroup = (
    props: IUseChangeActiveGroupProps,
): void => {
    const {
        activeGroup,
        options,
        selectorValue,
        handleClassChange,
        handleTypeChange,
        trainsDefaultActiveTab,
    } = props;
    const dispatch = useDispatch();

    useEffect(() => {
        if (trainsDefaultActiveTab && options.length) {
            if (selectorValue) {
                const activeOption = options.find(
                    option => option.value === selectorValue,
                );

                if (activeOption) {
                    return;
                }
            }

            const defaultTabValue = findDefaultActiveTabValue(options);

            if (defaultTabValue) {
                if (isTrainsCoachType(defaultTabValue)) {
                    handleTypeChange(defaultTabValue);
                } else {
                    handleClassChange(defaultTabValue);
                }
            }
        }
    }, [
        selectorValue,
        options,
        handleTypeChange,
        handleClassChange,
        trainsDefaultActiveTab,
    ]);

    useEffect(() => {
        if (!trainsDefaultActiveTab && !activeGroup && options.length) {
            const [firstGroup] = options;
            const firstGroupValue = firstGroup.value;

            if (isTrainsCoachType(firstGroupValue)) {
                dispatch(changeCoachType(firstGroupValue));
            }
        }
    }, [activeGroup, options, trainsDefaultActiveTab, dispatch]);
};

function findDefaultActiveTabValue(
    options: ITrainsTabsOption[],
): string | null {
    const defaultActiveTab = options.reduce<{
        totalPlaces: number;
        value: string | null;
    }>(
        (currentActiveTab, option) => {
            const {value, disabled, totalPlaces} = option;
            const currentTotalPlaces = currentActiveTab.totalPlaces;
            const currentValue = currentActiveTab.value;

            if (disabled) {
                return currentActiveTab;
            }

            /* Только для плацкартного вагона и сидячего смотрим на количество мест */
            if (
                value === TRAIN_COACH_TYPE.SITTING ||
                value === TRAIN_COACH_TYPE.PLATZKARTE
            ) {
                if (totalPlaces > currentTotalPlaces) {
                    return {value, totalPlaces};
                }
            }

            if (currentTotalPlaces || currentValue) {
                return currentActiveTab;
            }

            return {value, totalPlaces: currentTotalPlaces};
        },
        {totalPlaces: 0, value: null},
    );

    return defaultActiveTab.value;
}
