import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';
import {PLACE_RESERVATION_TYPE} from 'projects/trains/constants/placeReservationType';

import {ITrainsCoach} from 'reducers/trains/order/types';

import IPrice from 'utilities/currency/PriceInterface';

/*
 * Common
 */
interface ICoachPlaceTypeInfo {
    count: number;
    areAllPricesEqual: boolean;
    minPrice: IPrice;
}

export type TCoachPlaceTypesInfo = PartialRecord<string, ICoachPlaceTypeInfo>;

/*
 * Classes
 */
export interface ICoachesSimpleClass {
    key: string;
    code: string;
    title: string;
    description: string;
    owner: string;
    coaches: ITrainsCoach[];
    abilities: string[];
    facilities: string[];
}

export type TCoachesClassesSimpleGroup = PartialRecord<
    string,
    ICoachesSimpleClass
>;

export interface ICoachesClass extends ICoachesSimpleClass {
    placesAndPrices: TCoachPlaceTypesInfo | null;
    placeReservationType: PLACE_RESERVATION_TYPE;
}

export type TCoachesClassesGroup = PartialRecord<string, ICoachesClass>;

/*
 * Type group
 */
export interface ICoachesTypeSimpleGroup {
    coaches: ITrainsCoach[];
    type: TRAIN_COACH_TYPE;
}

export type TCoachesTypeSimpleGroups = PartialRecord<
    TRAIN_COACH_TYPE,
    ICoachesTypeSimpleGroup
>;

export interface ICoachesTypeGroup extends ICoachesTypeSimpleGroup {
    classes: ICoachesClass[];
}

export type TCoachesTypeGroups = PartialRecord<
    TRAIN_COACH_TYPE,
    ICoachesTypeGroup
>;
