import {ITrainsCoach, TrainsPassengersCount} from 'reducers/trains/order/types';

import {countPassengersWithPlaces} from 'projects/trains/lib/order/passengers/utils';
import getTrainsMaxAvailablePlacesToPurchaseInCoach from 'projects/trains/lib/order/coaches/getTrainsMaxAvailablePlacesToPurchaseInCoach';

interface ICheckCoachTabDisabledProps {
    coaches: ITrainsCoach[];
    passengers: TrainsPassengersCount;
    trainsDisableCoachTypeTabs?: boolean;
}

export const checkCoachTabDisabled = (
    props: ICheckCoachTabDisabledProps,
): boolean => {
    const {coaches, passengers, trainsDisableCoachTypeTabs} = props;

    if (!trainsDisableCoachTypeTabs) {
        return false;
    }

    if (!coaches || !passengers) {
        return true;
    }

    const totalPlaceNeed = countPassengersWithPlaces(passengers);

    return coaches.every(coach => {
        const coachPlaces = getTrainsMaxAvailablePlacesToPurchaseInCoach(coach);

        return coachPlaces < totalPlaceNeed;
    });
};
