import _isNumber from 'lodash/isNumber';

import {ITrainsCoach} from 'reducers/trains/order/types';

import {calculateCoachMinNonRefundableDiscount} from 'projects/trains/lib/order/coaches/calculateCoachMinNonRefundableDiscount';

export const getCoachTabNonRefundableDiscount = ({
    coaches,
}: {
    coaches: ITrainsCoach[];
}): number | undefined => {
    const coachDiscounts: number[] = coaches
        .map(coach => calculateCoachMinNonRefundableDiscount({coach}))
        .filter(
            (discount: number | undefined): discount is number =>
                _isNumber(discount) && discount > 0,
        );

    if (!coachDiscounts.length) {
        return;
    }

    return Math.min(...coachDiscounts);
};
