import {CHAR_WIDE_MIDDLE_DASH, CHAR_NBSP} from 'utilities/strings/charCodes';

export const getCoachTabTitleWithTotalPlaces = ({
    groupTitle,
    totalPlaces,
}: {
    groupTitle: string;
    totalPlaces: number;
}): string => {
    if (!totalPlaces) {
        return groupTitle;
    }

    return `${groupTitle}${CHAR_NBSP}${CHAR_WIDE_MIDDLE_DASH}${CHAR_NBSP}${totalPlaces}`;
};
