import React, {Component} from 'react';

import {GENDER_TYPE} from 'projects/trains/constants/genders';

import {ITrainsCoach, TrainsPassengersCount} from 'reducers/trains/order/types';
import {ITrainsSchema} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';

import {IDevice} from 'reducers/common/commonReducerTypes';

import {IPlaceMapItem} from 'projects/trains/lib/order/getPlaceMap';

import ErrorBoundary from 'components/ErrorBoundary/ErrorBoundary';
import SvgSchema, {
    ISchemaPlaceCoords,
    ISchemaPlaceNodeMapItem,
} from 'projects/trains/components/TrainsOrderPage/SvgSchema/SvgSchema';
import SchemeTooltip from 'projects/trains/components/TrainsOrderPage/SchemeTooltip/SchemeTooltip';

import cx from './SvgSchemaContainer.scss';

interface ISvgSchemaContainerProps {
    deviceType: IDevice;
    coach: ITrainsCoach;
    gender: GENDER_TYPE | null;
    schema: ITrainsSchema;
    placeMap: IPlaceMapItem[];
    passengers: TrainsPassengersCount;
    interactive: boolean;
    showTooltip: boolean;
    coachSchemaRenderingDelay?: number;
    schemaPlaceMaskPrefix: string;
    onPlaceClick({
        places,
        coords,
    }: {
        places: IPlaceMapItem[];
        coords: ISchemaPlaceCoords;
    }): void;
    onPlaceCoordsCalculated(
        placeNodeMap: PartialRecord<string, ISchemaPlaceNodeMapItem>,
    ): void;
    onCatchError(error?: Error, errorInfo?: React.ErrorInfo): void;
}

export default class SvgSchemaContainer extends Component<ISvgSchemaContainerProps> {
    renderError(): null {
        return null;
    }

    render(): React.ReactNode {
        const {
            deviceType,
            coach,
            coachSchemaRenderingDelay,
            gender,
            schema,
            schemaPlaceMaskPrefix,
            placeMap,
            passengers,
            interactive,
            showTooltip,
            onPlaceClick,
            onPlaceCoordsCalculated,
            onCatchError,
        } = this.props;

        return (
            <div className={cx('root')}>
                <ErrorBoundary
                    handleError={onCatchError}
                    renderError={this.renderError}
                >
                    <SvgSchema
                        deviceType={deviceType}
                        coachSchemaRenderingDelay={coachSchemaRenderingDelay}
                        coach={coach}
                        gender={gender}
                        schema={schema.svg}
                        schemaPlaceMaskPrefix={schemaPlaceMaskPrefix}
                        placeMap={placeMap}
                        interactive={interactive}
                        onPlaceClick={onPlaceClick}
                        onPlaceCoordsCalculated={onPlaceCoordsCalculated}
                    />
                </ErrorBoundary>

                {interactive && showTooltip && (
                    <SchemeTooltip
                        coach={coach}
                        schema={schema}
                        placeMap={placeMap}
                        passengers={passengers}
                    />
                )}
            </div>
        );
    }
}
