import React from 'react';

import {IWithDeviceType} from 'types/withDeviceType';
import {ITrainsCoach} from 'reducers/trains/order/types';
import {IWithClassName} from 'types/withClassName';

import {deviceMods} from 'utilities/stylesUtils';

import * as i18n from 'i18n/trains-coach-properties';

import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import ArrowLongRightIcon from 'icons/12/ArrowLongRight';

import cx from './SvgSchemaLegend.scss';

interface ISvgSchemaLegendProps extends IWithClassName, IWithDeviceType {
    coach: ITrainsCoach;
}

const SvgSchemaLegend: React.FC<ISvgSchemaLegendProps> = props => {
    const {className, coach, deviceType} = props;

    if (!coach.directionConfirmed) {
        return null;
    }

    return (
        <div className={cx('root', className)}>
            <div
                className={cx('direction', deviceMods('direction', deviceType))}
            >
                <TextWithIcon
                    className={cx('label')}
                    text={i18n.movementDirection()}
                    size="s-inset"
                    iconRight={ArrowLongRightIcon}
                    iconRightClassName={cx('labelIcon')}
                />
            </div>
        </div>
    );
};

export default SvgSchemaLegend;
